/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.bytedisplay;

import javax.swing.text.JTextComponent;

public class ByteDisplayThread
extends Thread {
    private JTextComponent jtc;
    private byte[] bytes;
    private int delay;
    private float multiplicator;

    public ByteDisplayThread(JTextComponent jtc, int delay, float multiplicator, String text) {
        this.jtc = jtc;
        this.delay = delay;
        this.multiplicator = multiplicator;
        this.setByteText(text);
    }

    public ByteDisplayThread(JTextComponent jtc, int delay, float multiplicator, byte[] bytes) {
        this.jtc = jtc;
        this.delay = delay;
        this.multiplicator = multiplicator;
        this.setByteText(bytes);
    }

    public void setByteText(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setByteText(String text) {
        this.bytes = new byte[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            this.bytes[i] = (byte)text.charAt(i);
        }
    }

    @Override
    public void run() {
        System.err.println("ByteDisplayThread is being run.");
        String currentText = "";
        System.err.println("Length: " + this.bytes.length);
        for (int i = 0; i < this.bytes.length; ++i) {
            int targetChar = (char)this.bytes[i] & 0xFF;
            for (int currentChar = 0; currentChar < targetChar; ++currentChar) {
                this.jtc.setText(String.format("%s%02x ", currentText, currentChar));
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep((int)(this.multiplicator * (float)this.delay));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            currentText = currentText + String.format("%02x ", targetChar);
            this.jtc.setText(currentText);
        }
    }
}

