/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.animation;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.granjow.animation.FPSThread;

public class SlideContainer
extends JPanel {
    private final Image pic;
    private final Dimension windowSize;
    private final int size;
    private long animationTime = 250L;
    private int _fps = 30;
    private FPSThread fpsThread;
    private FakeThread fakeThread;
    private boolean animate = false;
    private long animationStart = 0L;
    private int animationSrc = 0;
    private volatile int animationDest = 0;
    private Animation animationType = Animation.LINEAR;
    private MiniIntQueue q;

    public SlideContainer(String imgPath, int size, int width, int height, Animation animationType, int fps) {
        this(new ImageIcon(imgPath), size, width, height, animationType, fps);
    }

    public SlideContainer(ImageIcon ii, int size, int width, int height, Animation animationType, int fps) {
        super(true);
        this.size = size;
        this.animationType = animationType;
        this._fps = fps;
        this.fpsThread = new FPSThread(this, this._fps, this.animationTime);
        this.pic = ii.getImage();
        this.windowSize = new Dimension(width, height);
        this.q = new MiniIntQueue(size);
        System.out.println("Icon height: " + ii.getIconHeight());
    }

    public void setAnimationType(Animation animationType) {
        this.animationType = animationType;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, (int)this.windowSize.getWidth(), (int)this.windowSize.getHeight());
        int x = this.animationSrc * (int)this.windowSize.getWidth();
        long timeDiff = System.currentTimeMillis() - this.animationStart;
        if (timeDiff < this.animationTime) {
            double multiplier;
            int d = (this.animationDest - this.animationSrc) * (int)this.windowSize.getWidth();
            float completedFrac = (float)(System.currentTimeMillis() - this.animationStart) / (float)this.animationTime;
            switch (this.animationType) {
                case LINEAR: {
                    multiplier = completedFrac;
                    break;
                }
                case COSINE: {
                    multiplier = Math.cos(1.5707963267948966 * (double)completedFrac);
                    break;
                }
                case COSINE_FULL: {
                    multiplier = Math.cos(Math.PI * (double)completedFrac) / 2.0;
                    break;
                }
                case SINE: {
                    multiplier = Math.sin(1.5707963267948966 * (double)completedFrac);
                    break;
                }
                case SINE2: {
                    multiplier = Math.sin(1.5707963267948966 * (double)completedFrac) * Math.sin(1.5707963267948966 * (double)completedFrac);
                    break;
                }
                case SINE_: {
                    multiplier = Math.pow(Math.sin(1.5707963267948966 * (double)completedFrac), 1.5);
                }
                case SQUARE: {
                    multiplier = Math.sqrt(completedFrac);
                    break;
                }
                case HILL: {
                    multiplier = -2.5 * (double)completedFrac * (double)completedFrac + 3.5 * (double)completedFrac;
                    break;
                }
                default: {
                    multiplier = completedFrac;
                }
            }
            System.err.print("\tMultiplier: " + (Object)((Object)this.animationType) + " = " + multiplier);
            x = (int)((double)x + multiplier * (double)d);
        }
        x = -x;
        System.err.println("\tx is " + x);
        g.drawImage(this.pic, x, 0, null);
    }

    public boolean showPart(int dest) {
        System.err.print("Thread state: " + (Object)((Object)this.fpsThread.getState()));
        if (this.fpsThread.isAlive() || this.fpsThread.isInterrupted()) {
            if (dest != this.animationSrc) {
                System.err.println("\tLiving/interrupted, putting on Queue (" + this.animationSrc + "/" + dest + ")");
                if (dest < this.animationSrc) {
                    this.q.put(MiniIntQueue.Direction.LEFT);
                } else {
                    this.q.put(MiniIntQueue.Direction.RIGHT);
                }
            }
        } else if (dest >= 0 && dest < this.size && (this.fpsThread.getState() == Thread.State.TERMINATED || this.fpsThread.getState() == Thread.State.NEW)) {
            this.animationStart = System.currentTimeMillis();
            this.animationDest = dest;
            System.err.println("\tStarting new thread " + this.animationSrc + "->" + this.animationDest);
            this.fpsThread = new FPSThread(this, this._fps, this.animationTime);
            this.fpsThread.start();
            return true;
        }
        return false;
    }

    public void animationCleanup() {
        System.err.println("Cleanup called: " + this.animationDest);
        this.animationSrc = this.animationDest;
        this.repaint();
        this.fakeThread = new FakeThread(this.fpsThread, this);
        this.fakeThread.start();
    }

    public boolean showLeft() {
        return this.showPart(this.animationSrc - 1);
    }

    public boolean showRight() {
        return this.showPart(this.animationSrc + 1);
    }

    public boolean workQueue() {
        if (this.animationSrc <= 0) {
            this.q.purgeElements(MiniIntQueue.Direction.LEFT);
        }
        if (this.animationSrc >= this.size - 1) {
            this.q.purgeElements(MiniIntQueue.Direction.RIGHT);
        }
        try {
            MiniIntQueue.Direction newDirection = this.q.get();
            int newPart = this.animationSrc + 1 * newDirection.value;
            if (newPart >= 0 && newPart < this.size) {
                System.err.println("More work to do: " + (Object)((Object)newDirection));
                return this.showPart(newPart);
            }
            System.err.println("Index out of bounds: " + newPart);
        }
        catch (MiniIntQueue.QueueEmptyException e) {
            System.err.println("\t" + e.getMessage());
        }
        return false;
    }

    public int getSelectedPart() {
        return this.animationSrc;
    }

    private static class MiniIntQueue {
        public final int size;
        private Direction[] array;
        private int n = 0;
        private int start = 0;

        public MiniIntQueue(int size) {
            this.size = size;
            this.array = new Direction[size];
        }

        public void put(Direction dir) {
            if (this.n < this.size) {
                this.array[(this.start + this.n) % this.size] = dir;
                ++this.n;
            }
        }

        public Direction get() throws QueueEmptyException {
            if (this.n > 0) {
                Direction val = this.array[this.start];
                --this.n;
                ++this.start;
                this.start %= this.size;
                return val;
            }
            throw new QueueEmptyException();
        }

        public void purgeElements(Direction like) {
            try {
                while (this.n > 0 && this.array[this.start] == like) {
                    this.get();
                }
            }
            catch (QueueEmptyException queueEmptyException) {
                // empty catch block
            }
        }

        public class QueueEmptyException
        extends Exception {
            public QueueEmptyException() {
                super("Queue is empty!");
            }
        }

        public static enum Direction {
            LEFT(-1),
            RIGHT(1);

            public final int value;

            private Direction(int value) {
                this.value = value;
            }
        }
    }

    private class FakeThread
    extends Thread {
        private final FPSThread otherThread;
        private final SlideContainer container;

        public FakeThread(FPSThread otherThread, SlideContainer container) {
            this.otherThread = otherThread;
            this.container = container;
        }

        @Override
        public void run() {
            try {
                this.otherThread.join();
                System.err.print("Joined other thread");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println("\ttrying to work Queue.");
            this.container.workQueue();
        }
    }

    public static enum Animation {
        LINEAR,
        COSINE,
        COSINE_FULL,
        SINE,
        SINE2,
        SINE_,
        SQUARE,
        HILL;

    }
}

