/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.animation;

import net.granjow.animation.SlideContainer;

public class FPSThread
extends Thread {
    private final SlideContainer panel;
    private volatile int fps = 30;
    private volatile long duration = 1000L;
    private volatile int counter;
    private long startTime;
    private volatile long endTime;

    public FPSThread(SlideContainer panel, int fps, long duration) {
        this.panel = panel;
        this.fps = fps;
        this.duration = duration;
    }

    public void setAnimationTime(long duration) {
        this.duration = duration;
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + this.duration;
        float dt = 1000 / this.fps;
        this.counter = 0;
        do {
            this.panel.repaint();
            ++this.counter;
            long wait = (int)((float)this.counter * dt - (float)(System.currentTimeMillis() - this.startTime));
            if (wait < 0L) {
                wait = 10L;
                System.err.println("Few time");
            }
            try {
                Thread.sleep((int)wait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < this.endTime);
        this.panel.repaint();
        this.panel.animationCleanup();
    }
}

