/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.acpr;

public class ACProfileRenamerGenerator {
    public static final int MAXLENGTH = 25;
    public static final ACSymbol[] symbols = new ACSymbol[]{new ACSymbol("Feet", ":foot:", -94), new ACSymbol("Hand", ":hand:", -93), new ACSymbol("Hand 2", ":hand2:", -92), new ACSymbol("Arrow down", ":down:", -91), new ACSymbol("Arrow left", ":left:", -90), new ACSymbol("Arrow right", ":right:", -89), new ACSymbol("Hidden Blade", ":blade:", -81), new ACSymbol("Fist", ":fist:", -79), new ACSymbol("Eagle Vision", ":eagle:", -68), new ACSymbol("Short Sword", ":shortsword:", -67), new ACSymbol("Sword", ":sword:", -66), new ACSymbol("Lock", ":lock:", -78), new ACSymbol("Hood", ":hood:", -77), new ACSymbol("Camera", ":cam:", -75)};

    public static final String getUntaggedName(String profileName) {
        String untaggedName = profileName;
        for (ACSymbol sym : symbols) {
            if (untaggedName.contains(sym.symbolTag)) {
                System.out.printf("Replacing %s by 0x%02x\n", sym.symbolTag, sym.bytecode);
            }
            untaggedName = untaggedName.replace(sym.symbolTag, "" + (char)sym.bytecode);
        }
        return untaggedName;
    }

    public static final boolean isInBounds(String profileName) {
        System.err.println("Maxlength is 25, untagged Name is " + ACProfileRenamerGenerator.getUntaggedName(profileName) + ", l = " + ACProfileRenamerGenerator.getUntaggedName(profileName).length());
        return ACProfileRenamerGenerator.getUntaggedName(profileName).length() <= 25 && ACProfileRenamerGenerator.getUntaggedName(profileName).length() > 0;
    }

    public static final byte[] getByteSequence(String profileName) throws NameTooLongException {
        String untaggedName = ACProfileRenamerGenerator.getUntaggedName(profileName);
        byte[] bytes = new byte[untaggedName.length() * 2 + 4];
        int offset = 4;
        if (!ACProfileRenamerGenerator.isInBounds(profileName)) {
            throw new NameTooLongException(untaggedName.length());
        }
        bytes[0] = (byte)untaggedName.length();
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        for (int i = 0; i < untaggedName.length(); ++i) {
            bytes[2 * i + offset] = (byte)untaggedName.charAt(i);
            bytes[2 * i + offset + 1] = 0;
        }
        return bytes;
    }

    public static final String getTaggedName(String untaggedName) {
        String taggedName = untaggedName;
        for (ACSymbol sym : symbols) {
            if (taggedName.contains("" + (char)sym.bytecode)) {
                System.err.printf("Replacing %02x with tag %s\n", sym.bytecode, sym.symbolTag);
            }
            taggedName = taggedName.replace("" + (char)sym.bytecode, sym.symbolTag);
        }
        return taggedName;
    }

    public static final String loadByteSequence(byte[] bytes) {
        String plainName = "";
        byte length = bytes[0];
        int fileLength = length * 2 + 4;
        System.err.printf("Loaded file with length %d\n", length);
        for (int i = 4; i < fileLength; i += 2) {
            plainName = plainName + (char)bytes[i];
        }
        return plainName;
    }

    public static void main(String[] args) throws NameTooLongException {
        int i;
        if (args.length == 0) {
            return;
        }
        ACProfileRenamerGenerator png = new ACProfileRenamerGenerator();
        byte[] bytes = ACProfileRenamerGenerator.getByteSequence(args[0]);
        for (i = 0; i < bytes.length; ++i) {
            System.out.print((char)bytes[i]);
        }
        System.out.println();
        for (i = 0; i < bytes.length; ++i) {
            System.out.printf("%02x ", bytes[i]);
        }
        System.out.println();
    }

    public static class NameTooLongException
    extends Exception {
        NameTooLongException(int size) {
            super("Name is too long (" + size + "), maximum length is " + 25 + ".");
        }
    }

    static enum Symbols {
        PLACEHOLDER;

        static ACSymbol Feet;
        static ACSymbol Hand;
        static ACSymbol Hand2;
        static ACSymbol ArrowDown;
        static ACSymbol ArrowLeft;
        static ACSymbol ArrowRight;
        static ACSymbol HiddenBlade;
        static ACSymbol Fist;
        static ACSymbol EagleVision;
        static ACSymbol ShortSword;
        static ACSymbol Sword;
        static ACSymbol Lock;
        static ACSymbol Hood;
        static ACSymbol Camera;

        static {
            Feet = new ACSymbol("Feet", ":foot:", -94);
            Hand = new ACSymbol("Hand", ":hand:", -93);
            Hand2 = new ACSymbol("Hand 2", ":hand2:", -92);
            ArrowDown = new ACSymbol("Arrow down", ":down:", -91);
            ArrowLeft = new ACSymbol("Arrow left", ":left:", -90);
            ArrowRight = new ACSymbol("Arrow right", ":right:", -89);
            HiddenBlade = new ACSymbol("Hidden Blade", ":blade:", -81);
            Fist = new ACSymbol("Fist", ":fist:", -79);
            EagleVision = new ACSymbol("Eagle Vision", ":eagle:", -68);
            ShortSword = new ACSymbol("Short Sword", ":shortsword:", -67);
            Sword = new ACSymbol("Sword", ":sword:", -66);
            Lock = new ACSymbol("Lock", ":lock:", -78);
            Hood = new ACSymbol("Hood", ":hood:", -77);
            Camera = new ACSymbol("Camera", ":cam:", -75);
        }
    }

    private static class ACSymbol {
        final String symbolName;
        final String symbolTag;
        final byte bytecode;

        public ACSymbol(String symbolName, String symbolTag, byte bytecode) {
            this.symbolName = symbolName;
            this.symbolTag = symbolTag;
            this.bytecode = bytecode;
        }
    }
}

