/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.acpr;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.text.JTextComponent;
import net.granjow.acpr.ACPR_Resources;
import net.granjow.acpr.ACProfileFile;
import net.granjow.acpr.ACProfileRenamerFilechooser;
import net.granjow.acpr.ACProfileRenamerGenerator;
import net.granjow.acpr.ACProfileRenamerWriter;
import net.granjow.animation.SlideContainer;
import net.granjow.bytedisplay.ByteDisplayThread;

public class ACProfileRenamerGUI
extends JFrame {
    public static final Dimension SIZE = new Dimension(840, 525);
    private static BackgroundImagePanel loadScreen;
    private static BackgroundImagePanel nameScreen;
    private static BackgroundImagePanel doneScreen;
    private static BackgroundImagePanel doneRestoreScreen;
    private static BackgroundImagePanel failedScreen;
    private TaskSlider taskSlider = null;
    private State currentState = State.LOAD;
    private State nextState = State.LOAD;
    private State prevState = State.LOAD;
    private boolean ignoreNextKey = false;
    private ImageFrame helpFrame = null;
    private JTextFieldC jtfName = null;
    private JTextAreaT jtfDProfilename = null;
    private JTextAreaT jtaDFilename = null;
    private JButtonI jbSave = null;
    private JTextAreaT jtaErrorMessage = null;
    private ACByteDisplay disp = null;
    private String sName = "";
    private ACProfileFile hdrFile;
    private ACProfileFile hdrTargetFile;
    private String errMsg = "";
    private static final String newline;
    private static final Dimension screenSize;

    public ACProfileRenamerGUI() {
        super("Assassin's Creed Profile Renamer");
        this.setDefaultCloseOperation(3);
        this.setSize(SIZE);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setLayout(null);
        loadScreen = new BackgroundImagePanel(ACPR_Resources.i().iiLoad.getImage(), SIZE);
        nameScreen = new BackgroundImagePanel(ACPR_Resources.i().iiName.getImage(), SIZE);
        doneScreen = new BackgroundImagePanel(ACPR_Resources.i().iiDone.getImage(), SIZE);
        doneRestoreScreen = new BackgroundImagePanel(ACPR_Resources.i().iiDoneRestore.getImage(), SIZE);
        failedScreen = new BackgroundImagePanel(ACPR_Resources.i().iiFailed.getImage(), SIZE);
        this.addKeyListener(this.nextStateLogic());
        this.addMouseListener(this.mousie());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                System.err.println("Regained focus. " + (Object)((Object)ACProfileRenamerGUI.this.currentState));
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                System.err.print("Got the focus again. Updating state: ");
                ACProfileRenamerGUI.this.updateState();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        this.setLocation((int)(screenSize.getWidth() - SIZE.getWidth()) / 2, (int)(screenSize.getHeight() - SIZE.getHeight()) / 2);
        this.paintLoad();
        this.setVisible(true);
    }

    private KeyListener nextStateLogic() {
        return new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.err.printf("(Key: %d) ", e.getKeyCode());
                if (ACProfileRenamerGUI.this.ignoreNextKey) {
                    System.err.println("\tWill ignore this key.");
                    ACProfileRenamerGUI.this.ignoreNextKey = false;
                } else if (e.getKeyCode() == 112) {
                    if (ACProfileRenamerGUI.this.currentState != State.HELP) {
                        ACProfileRenamerGUI.this.getHelpFrame().setVisible(true);
                        ACProfileRenamerGUI.this.nextState = State.HELP;
                        ACProfileRenamerGUI.this.prevState = ACProfileRenamerGUI.this.currentState;
                        System.err.println("Previous state was " + (Object)((Object)ACProfileRenamerGUI.this.prevState));
                    } else {
                        System.err.println("Ignoring; F1 pressed again, no change required.");
                    }
                } else if (ACProfileRenamerGUI.this.nextState != State.TEMP) {
                    block1 : switch (ACProfileRenamerGUI.this.currentState) {
                        case HELP: {
                            ACProfileRenamerGUI.this.nextState = ACProfileRenamerGUI.this.prevState;
                            break;
                        }
                        case TASK: {
                            switch (e.getKeyCode()) {
                                case 39: {
                                    ACProfileRenamerGUI.this.getTaskSlider().showRight();
                                    break block1;
                                }
                                case 37: {
                                    ACProfileRenamerGUI.this.getTaskSlider().showLeft();
                                    break block1;
                                }
                                case 27: 
                                case 81: {
                                    ACProfileRenamerGUI.this.nextState = State.LOAD;
                                    break block1;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 38: 
                                case 40: 
                                case 144: 
                                case 145: 
                                case 154: 
                                case 157: 
                                case 524: 
                                case 65312: 
                                case 65406: {
                                    break block1;
                                }
                            }
                            switch (ACProfileRenamerGUI.this.getTaskSlider().getSelectedPart()) {
                                case 0: {
                                    ACProfileRenamerGUI.this.getTaskSlider().dispose();
                                    ACProfileRenamerGUI.this.nextState = State.TEMP;
                                    if (ACProfileRenamerGUI.this.loadFile() && ACProfileRenamerGUI.this.loadTargetFile()) {
                                        try {
                                            ACProfileRenamerGUI.this.hdrFile.copyFileGroup(ACPR_Resources.i().acDir, ACProfileRenamerGUI.this.hdrTargetFile.getBasename(false));
                                            ACProfileRenamerGUI.this.hdrFile = ACProfileRenamerGUI.this.hdrTargetFile;
                                            System.err.println("Will show renaming screen.");
                                        }
                                        catch (Exception ex) {
                                            ACProfileRenamerGUI.this.errMsg = ACProfileRenamerGUI.this.errMsg + ex.getMessage();
                                            ACProfileRenamerGUI.this.nextState = State.FAILED;
                                            break;
                                        }
                                        ACProfileRenamerGUI.this.nextState = State.BACKUP_RENAME;
                                        break;
                                    }
                                    System.err.println("Loading error!");
                                    ACProfileRenamerGUI.this.nextState = State.FAILED;
                                    break;
                                }
                                case 1: {
                                    ACProfileRenamerGUI.this.getTaskSlider().dispose();
                                    if (ACProfileRenamerGUI.this.loadBackupFile()) {
                                        ACProfileRenamerGUI.this.nextState = State.RESTORE;
                                        break;
                                    }
                                    ACProfileRenamerGUI.this.nextState = State.FAILED;
                                    break;
                                }
                                case 2: {
                                    ACProfileRenamerGUI.this.getTaskSlider().dispose();
                                    if (!ACProfileRenamerGUI.this.loadFile()) break;
                                    ACProfileRenamerGUI.this.nextState = State.NAME;
                                }
                            }
                            break;
                        }
                        case LOAD: {
                            switch (e.getKeyCode()) {
                                case 27: {
                                    System.exit(0);
                                    break block1;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 144: 
                                case 145: 
                                case 154: 
                                case 157: 
                                case 524: 
                                case 65312: 
                                case 65406: {
                                    break block1;
                                }
                            }
                            ACProfileRenamerGUI.this.nextState = State.TASK;
                            break;
                        }
                        case NAME: 
                        case BACKUP_RENAME: {
                            ACProfileRenamerGUI.this.sName = ACProfileRenamerGUI.this.getJtfName().getText();
                            switch (e.getKeyCode()) {
                                case 27: {
                                    ACProfileRenamerGUI.this.nextState = State.LOAD;
                                    break block1;
                                }
                                case 10: {
                                    break block1;
                                }
                            }
                            ACProfileRenamerGUI.this.checkCorrectLength();
                            break;
                        }
                        case DONE: {
                            switch (e.getKeyCode()) {
                                case 81: {
                                    System.exit(0);
                                    break block1;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 144: 
                                case 145: 
                                case 154: 
                                case 157: 
                                case 524: 
                                case 65312: 
                                case 65406: {
                                    break block1;
                                }
                            }
                            ACProfileRenamerGUI.this.nextState = State.LOAD;
                            break;
                        }
                        case FAILED: {
                            switch (e.getKeyCode()) {
                                case 27: {
                                    ACProfileRenamerGUI.this.nextState = State.LOAD;
                                }
                            }
                            break;
                        }
                    }
                }
                ACProfileRenamerGUI.this.updateState();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
    }

    private MouseListener mousie() {
        return new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                switch (ACProfileRenamerGUI.this.currentState) {
                    case LOAD: {
                        ACProfileRenamerGUI.this.nextState = State.TASK;
                        break;
                    }
                }
                ACProfileRenamerGUI.this.updateState();
            }
        };
    }

    private boolean loadFile() {
        ACProfileRenamerFilechooser fc = new ACProfileRenamerFilechooser();
        try {
            this.ignoreNextKey = true;
            this.hdrFile = fc.getHdrFile();
            return true;
        }
        catch (ACProfileRenamerFilechooser.NoFileChosenException e) {
            this.errMsg = this.errMsg + e.getMessage();
        }
        catch (ACProfileFile.NoHdrExtensionException noHdrExtensionException) {
            // empty catch block
        }
        return false;
    }

    private boolean writeFile() {
        try {
            this.hdrFile.writeProfileName(this.getJtfName().getText());
            return true;
        }
        catch (ACProfileRenamerWriter.WritingException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage() + newline;
        }
        catch (ACProfileRenamerWriter.BackupNotWritableException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage() + newline;
        }
        catch (ACProfileRenamerGenerator.NameTooLongException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage() + newline;
        }
        return false;
    }

    private boolean loadTargetFile() {
        ACProfileRenamerFilechooser fc = new ACProfileRenamerFilechooser();
        try {
            this.ignoreNextKey = true;
            this.hdrTargetFile = fc.getHdrTargetFile();
            return true;
        }
        catch (ACProfileRenamerFilechooser.NoFileChosenException e) {
            this.errMsg = this.errMsg + e.getMessage() + newline;
            e.printStackTrace();
        }
        catch (ACProfileFile.NoHdrExtensionException e) {
            this.errMsg = this.errMsg + e.getMessage() + newline;
            e.printStackTrace();
        }
        return false;
    }

    private boolean loadBackupFile() {
        ACProfileRenamerFilechooser fc = new ACProfileRenamerFilechooser();
        try {
            this.ignoreNextKey = true;
            this.hdrFile = fc.getHdrBackupFile();
            return true;
        }
        catch (ACProfileRenamerFilechooser.FileNotExistingException e) {
            this.errMsg = this.errMsg + e.getMessage() + newline;
            e.printStackTrace();
        }
        catch (ACProfileRenamerFilechooser.NoFileChosenException e) {
            this.errMsg = this.errMsg + e.getMessage() + newline;
            e.printStackTrace();
        }
        catch (ACProfileFile.NoHdrExtensionException e) {
            this.errMsg = this.errMsg + e.getMessage() + newline;
            e.printStackTrace();
        }
        return false;
    }

    private boolean createBackup() {
        try {
            this.hdrFile.copyFileGroup(ACPR_Resources.i().savesDir, this.hdrTargetFile.getBasename(false));
            System.err.println("Backup created.");
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage();
        }
        catch (ACProfileFile.IsNoDirectoryException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage();
        }
        catch (ACProfileFile.MissingFileException e) {
            e.printStackTrace();
            this.errMsg = this.errMsg + e.getMessage();
        }
        return false;
    }

    private void paintTask() {
        this.getTaskSlider().setVisible(true);
        this.getTaskSlider().requestFocus();
    }

    private void paintLoad() {
        this.setContentPane(loadScreen);
        this.destroy();
        this.requestFocus();
    }

    private void paintName() {
        this.setContentPane(nameScreen);
        this.destroy();
        this.getContentPane().add(this.getJtfName());
        this.getContentPane().add(this.getJbSave());
        this.getJtfName().grabFocus();
    }

    private void paintDone() {
        this.setContentPane(doneScreen);
        this.destroy();
        this.getContentPane().add(this.getJtfDProfilename());
        this.getContentPane().add(this.getJtaDFilename());
        this.getContentPane().add(this.getDisp());
        this.getDisp().showText(this.sName);
        this.requestFocus();
    }

    private void paintDoneRestore() {
        this.setContentPane(doneRestoreScreen);
        this.destroy();
        this.requestFocus();
    }

    private void paintFailed() {
        this.setContentPane(failedScreen);
        this.destroy();
        this.getContentPane().add(this.getJtaErrorMessage());
        this.requestFocus();
    }

    private void destroy() {
        this.getContentPane().removeAll();
        this.helpFrame = null;
        this.jtfName = null;
        this.jbSave = null;
        this.jtaErrorMessage = null;
        this.jtaDFilename = null;
        this.jtfDProfilename = null;
        this.disp = null;
        this.setLayout(null);
        if (this.taskSlider != null) {
            this.getTaskSlider().dispose();
        }
        this.taskSlider = null;
    }

    private void updateState() {
        System.err.println((Object)((Object)this.currentState) + "->" + (Object)((Object)this.nextState));
        block4 : switch (this.currentState) {
            case HELP: {
                this.nextState = this.prevState;
                System.err.println("Correction: " + (Object)((Object)this.currentState) + "->" + (Object)((Object)this.nextState));
                break;
            }
            case TASK: {
                switch (this.nextState) {
                    case LOAD: {
                        this.getTaskSlider().dispose();
                        this.paintLoad();
                        break;
                    }
                    case NAME: {
                        try {
                            this.sName = this.hdrFile.getProfileName();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.paintName();
                        break;
                    }
                    case BACKUP_RENAME: {
                        try {
                            this.sName = this.hdrFile.getProfileName();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.paintName();
                        break;
                    }
                    case RESTORE: {
                        try {
                            this.hdrFile.copyFileGroup(ACPR_Resources.i().acDir, this.hdrFile.getBasename(false));
                            System.err.println("Backup restored.");
                            this.nextState = State.DONE;
                            this.paintDoneRestore();
                        }
                        catch (Exception ex) {
                            this.errMsg = this.errMsg + ex.getMessage();
                            this.nextState = State.FAILED;
                            this.paintFailed();
                        }
                        break;
                    }
                    case FAILED: {
                        this.paintFailed();
                    }
                }
                break;
            }
            case LOAD: {
                switch (this.nextState) {
                    case NAME: {
                        try {
                            this.sName = this.hdrFile.getProfileName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.paintName();
                        break block4;
                    }
                    case TASK: {
                        this.paintTask();
                        break block4;
                    }
                }
                break;
            }
            case NAME: {
                switch (this.nextState) {
                    case LOAD: {
                        this.paintLoad();
                        break block4;
                    }
                    case DONE: {
                        if (this.writeFile()) {
                            this.paintDone();
                            break block4;
                        }
                        this.paintFailed();
                        this.nextState = State.FAILED;
                        break block4;
                    }
                }
                break;
            }
            case BACKUP_RENAME: {
                switch (this.nextState) {
                    case LOAD: {
                        this.paintLoad();
                        break;
                    }
                    case DONE: {
                        if (this.writeFile() && this.createBackup()) {
                            this.paintDone();
                            break;
                        }
                        this.paintFailed();
                        this.nextState = State.FAILED;
                    }
                }
                break;
            }
            case RESTORE: {
                System.err.println("State RESTORE reached");
                switch (this.nextState) {
                    case DONE: {
                        this.paintDoneRestore();
                        break block4;
                    }
                    case FAILED: {
                        this.paintFailed();
                        break block4;
                    }
                }
                break;
            }
            case DONE: {
                switch (this.nextState) {
                    case LOAD: {
                        this.paintLoad();
                        break block4;
                    }
                }
                break;
            }
            case FAILED: {
                switch (this.nextState) {
                    case LOAD: {
                        this.errMsg = "";
                        this.paintLoad();
                        break block4;
                    }
                }
            }
        }
        if (this.nextState != State.TEMP) {
            this.currentState = this.nextState;
        }
        if (this.helpFrame != null && this.currentState != State.HELP) {
            this.helpFrame.dispose();
            this.helpFrame = null;
        }
    }

    private void checkCorrectLength() {
        if (ACProfileRenamerGenerator.isInBounds(this.getJtfName().getText())) {
            this.getJtfName().setCorrectColor();
            this.getJbSave().setEnabled(true);
        } else {
            this.getJtfName().setIncorrectColor();
            this.getJbSave().setEnabled(false);
            System.err.printf("Out of Bounds: %s\n", this.getJtfName().getText());
        }
    }

    private ImageFrame getHelpFrame() {
        if (this.helpFrame == null) {
            this.helpFrame = new ImageFrame(this, new Dimension(100, 180), ACPR_Resources.i().iiHelp);
        }
        return this.helpFrame;
    }

    private JTextFieldC getJtfName() {
        if (this.jtfName == null) {
            this.jtfName = new JTextFieldC(this.sName);
            this.jtfName.setBounds(230, 235, 440, 30);
            this.jtfName.addKeyListener(this.nextStateLogic());
            this.jtfName.addMouseListener(new MouseListener(){

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ACProfileRenamerGUI.this.checkCorrectLength();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.jtfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ACProfileRenamerGUI.this.getJbSave().isEnabled()) {
                        ACProfileRenamerGUI.this.nextState = State.DONE;
                        ACProfileRenamerGUI.this.ignoreNextKey = true;
                        ACProfileRenamerGUI.this.updateState();
                    } else {
                        System.err.println("Won't save, name too long");
                    }
                }
            });
            this.checkCorrectLength();
        }
        return this.jtfName;
    }

    private JTextAreaT getJtfDProfilename() {
        if (this.jtfDProfilename == null) {
            this.jtfDProfilename = new JTextAreaT(Color.WHITE, Color.WHITE, this.sName);
            this.jtfDProfilename.setBounds(260, 201, 400, 80);
        }
        return this.jtfDProfilename;
    }

    private JTextAreaT getJtaDFilename() {
        if (this.jtaDFilename == null) {
            this.jtaDFilename = new JTextAreaT(Color.WHITE, Color.WHITE, this.hdrFile.getAbsolutePath());
            this.jtaDFilename.setBounds(260, 285, 400, 40);
        }
        return this.jtaDFilename;
    }

    private JButtonI getJbSave() {
        if (this.jbSave == null) {
            this.jbSave = new JButtonI(ACPR_Resources.urlBtnSave, ACPR_Resources.urlBtnSaveInactive);
            this.jbSave.setBounds(683, 237, 36, 28);
            this.jbSave.addKeyListener(this.nextStateLogic());
            this.jbSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ACProfileRenamerGUI.this.ignoreNextKey = true;
                    ACProfileRenamerGUI.this.nextState = State.DONE;
                    ACProfileRenamerGUI.this.updateState();
                }
            });
        }
        return this.jbSave;
    }

    private JTextAreaT getJtaErrorMessage() {
        if (this.jtaErrorMessage == null) {
            this.jtaErrorMessage = new JTextAreaT(Color.WHITE, Color.WHITE);
            this.jtaErrorMessage.setBounds(110, 245, 550, 220);
            this.jtaErrorMessage.setText(this.errMsg);
        }
        return this.jtaErrorMessage;
    }

    private ACByteDisplay getDisp() {
        if (this.disp == null) {
            this.disp = new ACByteDisplay(2, 40.0f);
            this.disp.setBounds(120, 370, 540, 100);
            this.disp.showText(ACProfileRenamerGenerator.getUntaggedName(this.sName));
        }
        return this.disp;
    }

    private TaskSlider getTaskSlider() {
        if (this.taskSlider == null) {
            this.taskSlider = new TaskSlider(this);
        }
        return this.taskSlider;
    }

    public static void main(String[] args) {
        ACProfileRenamerGUI gui = new ACProfileRenamerGUI();
    }

    static {
        newline = System.getProperty("line.separator");
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    }

    public class TaskSlider
    extends JWindow {
        private SlideContainer slider;

        public TaskSlider(JFrame parent) {
            Dimension d = new Dimension(600, 300);
            ACProfileRenamerGUI.this.setResizable(false);
            this.setLayout(null);
            this.slider = new SlideContainer(ACPR_Resources.i().iiSlider, 3, (int)d.getWidth(), (int)d.getHeight(), SlideContainer.Animation.SINE_, 30);
            this.setSize((int)d.getWidth(), (int)d.getHeight());
            this.setContentPane(this.slider);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    System.err.println("Key Pressed!");
                    switch (e.getKeyCode()) {
                        case 39: {
                            TaskSlider.this.slider.showRight();
                            break;
                        }
                        case 37: {
                            TaskSlider.this.slider.showLeft();
                        }
                    }
                }
            });
            this.setLocation((int)(screenSize.getWidth() - d.getWidth()) / 2, (int)(screenSize.getHeight() - d.getHeight()) / 2);
        }

        public void showRight() {
            this.slider.showRight();
        }

        public void showLeft() {
            this.slider.showLeft();
        }

        public int getSelectedPart() {
            return this.slider.getSelectedPart();
        }
    }

    public class ImageFrame
    extends JWindow {
        public ImageFrame(JFrame parent, Dimension offset, ImageIcon background) {
            ACProfileRenamerGUI.this.setDefaultCloseOperation(2);
            ACProfileRenamerGUI.this.setResizable(false);
            this.setLayout(null);
            this.setSize(new Dimension(background.getIconWidth(), background.getIconHeight()));
            this.setContentPane(new BackgroundImagePanel(ACPR_Resources.i().iiHelp.getImage(), this.getSize()));
            this.setLocation((int)(parent.getLocation().getX() + offset.getWidth()), (int)(parent.getLocation().getY() + offset.getHeight()));
            this.setVisible(true);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    ImageFrame.this.dispose();
                    System.out.println("test");
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ImageFrame.this.dispose();
                }
            });
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.requestFocus();
            }
        }
    }

    public class ACByteDisplay
    extends JTextArea {
        private final int delay;
        private final float multiplicator;
        private ByteDisplayThread thread;

        public ACByteDisplay(int delay, float multiplicator) {
            this.delay = delay;
            this.multiplicator = multiplicator;
            this.setForeground(new Color(255, 255, 255));
            this.setOpaque(false);
            this.setBorder(null);
            this.setFocusable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public void showText(String profileName) {
            byte[] bytes = new byte[]{0};
            try {
                bytes = ACProfileRenamerGenerator.getByteSequence(profileName);
            }
            catch (ACProfileRenamerGenerator.NameTooLongException e) {
                // empty catch block
            }
            for (byte b : bytes) {
                System.err.printf("%02d ", b);
            }
            System.out.println();
            if (this.thread != null) {
                this.thread.setByteText(bytes);
            } else {
                this.thread = new ByteDisplayThread((JTextComponent)this, this.delay, this.multiplicator, bytes);
            }
            try {
                this.thread.start();
            }
            catch (IllegalThreadStateException e) {
                System.err.println("Thread already started!");
            }
        }
    }

    public static class JTextAreaT
    extends JTextArea {
        private String defaultText = "";
        private final Color defaultTextColor;
        private final Color textColor;

        public JTextAreaT(Color defaultTextColor, Color textColor) {
            this.defaultTextColor = defaultTextColor;
            this.textColor = textColor;
            this.setOpaque(false);
            this.setBorder(null);
            this.setForeground(defaultTextColor);
            this.setFocusable(false);
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public JTextAreaT(Color defaultTextColor, Color textColor, String defaultText) {
            this(defaultTextColor, textColor);
            this.defaultText = defaultText;
            this.setText(defaultText);
        }

        public void setDefaultText() {
            super.setText(this.defaultText);
            this.setForeground(this.defaultTextColor);
            this.setFont(this.getFont().deriveFont(2));
        }

        @Override
        public void setText(String s) {
            super.setText(s);
            this.setForeground(this.textColor);
            this.setFont(this.getFont().deriveFont(0));
        }
    }

    private class JButtonI
    extends JButton {
        private ImageIcon iActive;
        private ImageIcon iInactive;

        public JButtonI(URL iconActive, URL iconInactive) {
            this.setContentAreaFilled(false);
            this.setBorder(null);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.iActive = new ImageIcon(iconActive);
            this.iInactive = new ImageIcon(iconInactive);
            this.setIcon(this.iActive);
            this.setDisabledIcon(this.iInactive);
            this.setEnabled(true);
        }
    }

    private class JTextFieldC
    extends JTextField {
        private final Color incorrectColor;
        private final Color correctColor;
        private final Color selectionColor;
        private final Color selectedTextColor;

        public JTextFieldC(String text) {
            super(text);
            this.incorrectColor = new Color(190, 130, 46);
            this.correctColor = new Color(255, 255, 255);
            this.selectionColor = new Color(216, 228, 238, 80);
            this.selectedTextColor = new Color(152, 92, 70);
            this.setSelectionColor(this.selectionColor);
            this.setOpaque(false);
            this.setBorder(null);
            this.setCorrectColor();
        }

        public void setIncorrectColor() {
            this.setForeground(this.incorrectColor);
        }

        public void setCorrectColor() {
            this.setForeground(this.correctColor);
        }
    }

    private class BackgroundImagePanel
    extends JPanel {
        private Image img;

        public BackgroundImagePanel(Image img, Dimension size) {
            this.img = img;
            this.setSize(size);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, null);
        }
    }

    static enum State {
        TASK,
        LOAD,
        NAME,
        DONE,
        FAILED,
        HELP,
        BACKUP_RENAME,
        RESTORE,
        TEMP;

    }
}

