/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.acpr;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.granjow.acpr.ACPR_Resources;
import net.granjow.acpr.ACProfileFile;
import net.granjow.acpr.ACProfileRenamerGUI;
import net.granjow.acpr.ACProfileRenamerReader;

public class ACProfileRenamerFilechooser
extends JFileChooser {
    public ACProfileRenamerFilechooser() {
        super(ACPR_Resources.i().acDir);
        this.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "*.hdr (AC Profile Name files)";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".hdr") || f.isDirectory();
            }
        });
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(false);
        this.setAccessory(new NamePreview(this));
    }

    public ACProfileFile getHdrFile() throws NoFileChosenException, ACProfileFile.NoHdrExtensionException {
        this.setDialogTitle("Open Assassin's Creed Savegame");
        this.setCurrentDirectory(ACPR_Resources.i().acDir);
        int val = this.showOpenDialog(null);
        if (val != 0) {
            throw new NoFileChosenException("Source .hdr file");
        }
        return new ACProfileFile(this.getSelectedFile().getAbsolutePath());
    }

    public ACProfileFile getHdrBackupFile() throws NoFileChosenException, FileNotExistingException, ACProfileFile.NoHdrExtensionException {
        File f;
        this.setDialogTitle("Open Assassin's Creed Backup File");
        this.setCurrentDirectory(ACPR_Resources.i().savesDir);
        int val = this.showOpenDialog(null);
        if (val != 0) {
            throw new NoFileChosenException(".hdr backup file");
        }
        String filename = this.getSelectedFile().getAbsolutePath();
        if (!filename.endsWith(".hdr")) {
            filename = filename + ".hdr";
        }
        if (!(f = new File(filename)).exists()) {
            throw new FileNotExistingException(filename);
        }
        return new ACProfileFile(filename);
    }

    public ACProfileFile getHdrTargetFile() throws NoFileChosenException, ACProfileFile.NoHdrExtensionException {
        File f;
        String sNFC = "Target .hdr file";
        this.setDialogTitle("New File: Assassin's Creed Savegame Clone");
        this.setCurrentDirectory(ACPR_Resources.i().acDir);
        this.setSelectedFile(new File("assassination-of-whom.hdr"));
        int val = this.showSaveDialog(null);
        if (val != 0) {
            throw new NoFileChosenException(sNFC);
        }
        String filename = this.getSelectedFile().getAbsolutePath();
        if (!filename.endsWith(".hdr")) {
            filename = filename + ".hdr";
        }
        if ((f = new File(filename)).exists()) {
            int answer = JOptionPane.showConfirmDialog(null, filename + " will be overwritten. Okay?");
            if (answer == 2) {
                throw new NoFileChosenException(sNFC);
            }
            if (answer == 1) {
                return this.getHdrTargetFile();
            }
        }
        return new ACProfileFile(filename);
    }

    public static void main(String[] args) throws NoFileChosenException, ACProfileFile.NoHdrExtensionException {
        ACProfileRenamerFilechooser acfc = new ACProfileRenamerFilechooser();
        acfc.getHdrFile();
    }

    public class NamePreview
    extends JComponent
    implements PropertyChangeListener {
        private ACProfileFile currentFile = null;
        private ACProfileRenamerGUI.JTextAreaT jtaProfilename = null;
        private ACProfileRenamerGUI.JTextAreaT jtaLastModified = null;
        private Dimension size = new Dimension(400, 320);
        private final Color textColor = new Color(25, 25, 25);

        public NamePreview(JFileChooser jfc) {
            jfc.addPropertyChangeListener(this);
            this.add(this.getJtaProfilename());
            this.add(this.getLastModified());
            this.setPreferredSize(this.size);
            this.setVisible(true);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(ACPR_Resources.i().iiBackground.getImage(), 0, 0, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean update = false;
            if ("directoryChanged".equals(e.getPropertyName())) {
                update = true;
                this.currentFile = null;
            } else if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
                update = true;
                if (e.getNewValue() != null) {
                    try {
                        this.currentFile = new ACProfileFile(((File)e.getNewValue()).getAbsolutePath());
                    }
                    catch (ACProfileFile.NoHdrExtensionException noHdrExtensionException) {
                        // empty catch block
                    }
                    if (!(this.currentFile == null || this.currentFile.exists() && this.currentFile.isFile())) {
                        this.currentFile = null;
                    }
                } else {
                    this.currentFile = null;
                }
            }
            if (update) {
                this.update();
            }
        }

        private void update() {
            File f;
            this.getJtaProfilename().setText("");
            long lastModified = 0L;
            if (this.currentFile != null && this.currentFile.exists() && this.currentFile.isFile() && this.currentFile.canRead() && (f = new File(this.currentFile.getAbsolutePath().substring(0, this.currentFile.getAbsolutePath().length() - 4) + ".sav")).exists()) {
                lastModified = f.lastModified();
            }
            if (this.currentFile != null) {
                try {
                    this.getJtaProfilename().setText(this.currentFile.getProfileName());
                }
                catch (ACProfileRenamerReader.ReadingException e) {
                    e.printStackTrace();
                }
            } else {
                this.getJtaProfilename().setDefaultText();
            }
            if (lastModified != 0L) {
                Date modifiedDate = new Date(lastModified);
                String sDate = DateFormat.getDateInstance(1).format(modifiedDate);
                sDate = sDate + System.getProperty("line.separator");
                sDate = sDate + DateFormat.getTimeInstance(1).format(modifiedDate);
                this.getLastModified().setText(sDate);
            } else {
                this.getLastModified().setDefaultText();
            }
        }

        private ACProfileRenamerGUI.JTextAreaT getJtaProfilename() {
            if (this.jtaProfilename == null) {
                int x = 20;
                int y = 50;
                this.jtaProfilename = new ACProfileRenamerGUI.JTextAreaT(Color.WHITE, this.textColor, "The profile name will be displayed here.");
                this.jtaProfilename.setBounds(x, y, (int)this.size.getWidth() - 2 * x, 100);
                this.jtaProfilename.setForeground(new Color(255, 255, 255));
                this.jtaProfilename.setDefaultText();
            }
            return this.jtaProfilename;
        }

        private ACProfileRenamerGUI.JTextAreaT getLastModified() {
            if (this.jtaLastModified == null) {
                int x = 20;
                int y = 200;
                this.jtaLastModified = new ACProfileRenamerGUI.JTextAreaT(Color.WHITE, this.textColor, "The date you have last played this savegame will be displayed here.");
                this.jtaLastModified.setBounds(x, y, (int)this.size.getWidth() - 2 * x, (int)this.size.getHeight() - y - (int)(1.615 * (double)x));
                this.jtaLastModified.setForeground(new Color(255, 255, 255));
                this.jtaLastModified.setDefaultText();
            }
            return this.jtaLastModified;
        }
    }

    public class FileNotExistingException
    extends Exception {
        public FileNotExistingException(String filename) {
            super(filename + " does not exist!");
        }
    }

    public class NoFileChosenException
    extends Exception {
        public NoFileChosenException(String expectedFileType) {
            super("No file chosen. Expected: " + expectedFileType);
        }
    }
}

