/*
 * Decompiled with CFR 0.152.
 */
package net.granjow.acpr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import net.granjow.acpr.ACPR_Resources;
import net.granjow.acpr.ACProfileRenamerGenerator;
import net.granjow.acpr.ACProfileRenamerReader;
import net.granjow.acpr.ACProfileRenamerWriter;

public class ACProfileFile
extends File {
    private static final long serialVersionUID = 1L;

    public ACProfileFile(String s) throws NoHdrExtensionException {
        super(s);
        if (!s.endsWith(".hdr")) {
            throw new NoHdrExtensionException(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProfileName() throws ACProfileRenamerReader.ReadingException {
        String profileName = new String();
        byte[] bytes = ACProfileRenamerReader.readFile(this);
        profileName = ACProfileRenamerGenerator.loadByteSequence(bytes);
        profileName = ACProfileRenamerGenerator.getTaggedName(profileName);
        return profileName;
    }

    public void writeProfileName(String profileName) throws ACProfileRenamerWriter.WritingException, ACProfileRenamerWriter.BackupNotWritableException, ACProfileRenamerGenerator.NameTooLongException {
        String untaggedName = ACProfileRenamerGenerator.getUntaggedName(profileName);
        byte[] bytes = ACProfileRenamerGenerator.getByteSequence(untaggedName);
        ACProfileRenamerWriter.writeFile(this.getAbsolutePath(), bytes);
    }

    public String getBasename(boolean absolute) {
        if (absolute) {
            return this.getAbsolutePath().substring(0, this.getAbsolutePath().length() - 4);
        }
        return this.getName().substring(0, this.getName().length() - 4);
    }

    private File[] getFileGroup() throws MissingFileException {
        String basename = this.getBasename(true);
        File[] files = new File[]{this, new File(basename + ".sav"), new File(basename + ".opt"), new File(basename + ".map")};
        for (int i = 0; i < 2; ++i) {
            if (files[i].exists()) continue;
            throw new MissingFileException(files[i].getAbsolutePath());
        }
        if (!files[3].exists()) {
            files[3] = null;
        }
        if (!files[2].exists()) {
            files[2] = null;
        }
        return files;
    }

    public boolean isCompleteFilegroup() {
        try {
            this.getFileGroup();
            return true;
        }
        catch (MissingFileException missingFileException) {
            return false;
        }
    }

    public void copyFileGroup(File dir, String newName) throws FileNotFoundException, IOException, MissingFileException, IsNoDirectoryException {
        File[] files;
        for (File f : files = this.getFileGroup()) {
            if (f == null) continue;
            if (newName == null) {
                this.copyTo(f, dir);
                continue;
            }
            System.err.println("New name will be " + newName + f.getName().substring(f.getName().length() - 4));
            this.copyTo(f, dir, newName + f.getName().substring(f.getName().length() - 4));
        }
    }

    private void copyTo(File file, File dir) throws FileNotFoundException, IOException, IsNoDirectoryException {
        this.copyTo(file, dir, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTo(File file, File dir, String newName) throws FileNotFoundException, IOException, IsNoDirectoryException {
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (dir.isDirectory()) {
            File newFile = new File(dir.getAbsolutePath() + File.separator + newName);
            System.err.println("newName: " + newName);
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int len;
                System.err.print("Can write " + newFile.getAbsolutePath() + "? \t1 " + newFile.canWrite());
                newFile.getParentFile().mkdirs();
                newFile.createNewFile();
                System.err.println("\t2 " + newFile.canWrite());
                fis = new FileInputStream(file);
                fos = new FileOutputStream(newFile, false);
                byte[] bytes = new byte[4096];
                while ((len = fis.read(bytes)) > 0) {
                    fos.write(bytes, 0, len);
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {}
            }
            return;
        }
        throw new IsNoDirectoryException(dir.getAbsolutePath());
    }

    public ACProfileFile renameFileGroup(String newName) throws MissingFileException, RenamingFileException {
        String basepath = this.getParent() == null ? "" : this.getParent() + File.separator;
        File[] files = this.getFileGroup();
        ACProfileFile f = null;
        try {
            f = new ACProfileFile(basepath + newName + ".hdr");
        }
        catch (NoHdrExtensionException e) {
            e.printStackTrace();
        }
        if (!files[0].renameTo(f)) {
            throw new RenamingFileException(files[0].getAbsolutePath(), f.getAbsolutePath());
        }
        files[1].renameTo(new File(basepath + newName + ".sav"));
        if (files[2] != null) {
            files[2].renameTo(new File(basepath + newName + ".opt"));
        }
        if (files[3] != null) {
            files[3].renameTo(new File(basepath + newName + ".map"));
        }
        System.err.println("Renamed files to " + newName);
        return f;
    }

    public static void main(String[] args) throws ACProfileRenamerReader.ReadingException, ACProfileRenamerWriter.WritingException, ACProfileRenamerWriter.BackupNotWritableException, ACProfileRenamerGenerator.NameTooLongException, NoHdrExtensionException, MissingFileException, FileNotFoundException, IOException, IsNoDirectoryException, RenamingFileException {
        ACProfileFile f = new ACProfileFile("newtest.hdr");
        System.err.println(f.getBasename(true));
        f.writeProfileName(":sword: evil");
        f.getFileGroup();
        f = f.renameFileGroup("secondtest");
        f.copyFileGroup(ACPR_Resources.i().savesDir, null);
        System.err.println(new Date(f.lastModified()).toString());
    }

    public class RenamingFileException
    extends Exception {
        public RenamingFileException(String filenameFrom, String filenameTo) {
            super(String.format("File %s could not be renamed to %s!", filenameFrom, filenameTo));
        }
    }

    public class IsNoDirectoryException
    extends Exception {
        public IsNoDirectoryException(String filename) {
            super(String.format("Cannot copy files to %s, is not a directory!", filename));
        }
    }

    public class MissingFileException
    extends Exception {
        public MissingFileException(String filename) {
            super(String.format("Missing file (%s)! Mandatory for AC savegames!", filename));
        }
    }

    public class NoHdrExtensionException
    extends Exception {
        public NoHdrExtensionException(String filename) {
            super(String.format("File %s does not end with .hdr!", filename));
        }
    }
}

